It can be intimidating to think about these various tasks, especially if you’re a new homeowner. It’s a long list — there’s no denying that. The good news is that you can do the majority of it on your own without much experience. Google is your best friend, and if you really get stuck, call up your local handyman to help you out.

In order to maximize your efficiency and actually get all of these tasks done, you might want to create a home maintenance calendar for yourself. Whether online or on paper, you can jot down small, regular tasks for each weekend and not be too overwhelmed. We’ve listed tasks that need to be done monthly, quarterly, and biannually. We’ve also given you a list of tasks to be completed seasonally. Not every expert agrees as to which task needs to be done in which season, so this isn’t a black and white list, necessarily. Do what works for you and your schedule, and as long as all these things get accomplished, your home will be happy for years and years to come.

# **Monthly**

-   **Inspect, and possibly change out HVAC filters.** Many experts will say to change the filters monthly, but that’s not always necessary. For smaller families without pets or allergies, you’ll likely be okay changing the filters every 2-3 months. If the filter is dirty, change it out, otherwise inspect it again next month. I’ve also been told by handymen to go with cheaper filters and replace them more often versus going with the expensive filters. (You can also get it out of your mind by using a delivery service like [Cleaner Filters](https://www.secondnature.com/).)
-   **Clean kitchen sink disposal.** There are a bunch of ways to do this, but the handiest and best all-around solution seems to be vinegar ice cubes. Put some vinegar in an ice tray and let it freeze, then run the ice cubes through the disposal. It freshens it, but as a bonus, ice sharpens the blades. You’re welcome.
-   **Clean range hood filters.** If you’ve never thought of doing this, you’re in for a real “treat” when you get that filter off the hood to clean it for the first time. The [Family Handyman](https://www.familyhandyman.com/list/kitchen-cleaning-checklist-tips-for-a-clean-kitchen/#step1) suggests simply using a degreaser from an auto parts store mixed with hot water. Let the filter sit for a few minutes, rinse it off, and you’re good to go.
-   **Inspect your fire extinguisher(s).** We’ll assume you have and know how to use an extinguisher. This inspection doesn’t require much: ensure it has easy access (not being blocked by a garbage can or anything else), that the gauge shows adequate pressure, and that it has no visible signs of wear and tear.

# **Quarterly**

-   **Test smoke/carbon dioxide detectors.**Another simple task; your detectors should have a “test” button. If the alarm sounds, you’re good to go. If not, replace batteries immediately and test again. If it still doesn’t sound, it’s possible there’s simply corrosion on the battery terminal, and it won’t detect new batteries. Clean it and try again. If it still doesn’t work, you’ll likely need a new detector.
-   **Test garage door auto-reverse feature.** In 1993, federal law required all garage doors to have this feature after multiple child deaths. Test every month by placing a 2×4 on the ground where the door would close. It should reverse after a second or so when the door hits the wood. Also test the photo-electric sensors if you have them by placing something in front of them (not your body). If the door doesn’t immediately go back up, you have a problem.
-   **Run water and flush toilets in unused spaces.** This mostly applies to guest bathrooms, or any other sinks/water sources you don’t use on a regular basis. The idea is to prevent grime or any other kind of build up. Regularly running a little bit of water through will prevent this.
-   **Check water softener, add salt if needed.**You shouldn’t need to add salt every month, but better to check anyway, as it only takes about 5 seconds.

# **Biannually**

-   **[Test your water heater’s pressure relief valve](https://www.dummies.com/home-garden/plumbing/water-heaters/testing-your-water-heater-temperature-and-pressure-relief-valve/)**. This will prevent mineral and corrosion buildup, which safeguards against leaks. It will also help your heater run more efficiently.
-   **Give your house a deep clean.** Take one Saturday every six months with your whole family, and give the whole house a proper deep clean. Appliances, windows, dusting every nook and cranny (including the basement), etc. Keeping things clean and not letting dirt/grime/dust build up over years and years will help keep your home in tip-top shape.
-   **Replace batteries in smoke/carbon dioxide detectors.** I’d never heard this before, actually. I just assumed you changed it out when it started giving you the low battery beeping noise. This tip was in everything we researched, however. With something as important as this, you can’t be too careful, and batteries won’t break your bank. Change ‘em out every six months.
-   **[Vacuum your refrigerator coils](https://www.diylife.com/).** I actually learned this tip from a refrigerator repairman, and our research confirmed it. The fridge can use up to 15 percent of your home’s total power, so you want it running as efficiently as possible. Over time, the coils get dirty and your fridge requires more juice. You can save up to $100 a year by doing this, and it’s not at all a difficult task.

# **Annually (Organized by Season)**

# **Spring**

Spring is a big month for home maintenance. They don’t call it “Spring Cleaning” for nothing. Especially focus on the exterior of your home as it’s just gone through winter and is preparing for summer heat, and in some parts of the country, brutal humidity.

-   **Check the exterior drainage.** Will rain water flow away from the house? Puddles should not stand around your home for more than 24 hours. If water stays, or moves toward your foundation, you have a few options. First, check your gutters. It could be a bad spout or a loose connection there; they may also just need cleaning. Second, you can grade the area around your home yourself with some dirt; this has worked just fine for me in the past. Third, for pavement, you can have professionals come out and raise it so it drains away from your home.
-   **Clean out gutters.** They’ve likely accumulated leaves from the fall and grime/sediment from the winter snows and/or rains.
-   **Inspect the exterior of your home.** Is any paint chipping? Is any siding damaged from winter? Are there any holes in your brick? Take a close look all around your house, and make any repairs as needed. Also be sure to check the foundation for any cracks. A good silicone/caulk can fix a lot of your problems.
-   **Get your air conditioning system ready for summer; consider having it serviced.** This one really depends on your individual home, and even which part of the country you live in. Some places mostly just use window air units, while other places (like my home in Colorado) use a big swamp cooler up on the roof — these are fairly basic machines where a quick internet search can help you fix any issues that come up. Also refer to the user guides for specific regular maintenance. Central air is obviously a more complex system. Getting it serviced by a professional should be around $100 or less, and it will save money and headaches down the road.
-   **Repair/replace damaged window screens.**You don’t want bugs making their way in because you missed a hole in a window screen. And no, duct tape doesn’t count. It can be a quick fix, but don’t leave it for long. It just looks bad.
-   **Clear dead plants/shrubs from the house.**This could double as a gardening tip, but if you didn’t trim trees or shrubs in the fall, do so now. Plants can weasel their way into cracks and holes on the exterior of your home, causing damage and shortened longevity. Nip that in the bud before it’s an issue. If you have decorative vines on the exterior, pay close attention.
-   **Check trees for interference with electric lines.** Have professionally trimmed if necessary.
-   **Inspect roofing for damage, leaks, etc.**Repair as needed; you may need a professional.

# **Summer**

Summer is a great time to focus on the exterior of your home, as well as your lawn and garden. It’s also perfect for having that garage door open and utilizing the prolonged daylight to work on any manly projects you’ve had on the backburner.

-   **Check grout in bathrooms, kitchen, etc.; repair as needed.** This will prolong the life of your tiled surfaces and just looks better.
-   **Inspect plumbing for leaks, clean aerators on faucets.** Go around to all your faucets and toilets and check for any small leaks. If you have poor water pressure out of a faucet, the aerator is the likely culprit and it’s an extremely easy fix.
-   **Take care of any insect problems you may have.** Summer is their playground. You probably won’t have to look too hard to notice any insect problems. Ants, spiders, moths, etc. are all common, and fairly easy to take care of. Keep cobwebs clear, have ant poison handy, make sure all doors are tightly closed, etc.
-   **Clean and repair deck/patio as needed.** It generally just needs a good washing. A deck may also need re-staining. Also check for any loose boards or posts and repair as needed.
-   **Clean out window wells of debris.** If you have a basement, you also have window wells. All kinds of things can get down in there from leaves, to trash, to animals.
-   **Check and clean dryer vent, other exhaust vents to exterior of home.** While the dryer is running, check that the exhaust is coming out. It should smell nicely of fresh laundry. If there isn’t much exhaust, check for blockages as well as you can. You may need a professional. Also vacuum the lint from the hose at the dryer.
-   **Clean garage.** Cleaning the garage should be a summer ritual for every man. Keeping it clean and tidy will extend its life, and it often gets neglected of regular care. With all the extra dust it gets from the manly projects you’re working on, you should actually clean it even more. Once a year, however, give a thorough going-through.

# **Fall**

Fall is an in-between season where you’re finishing up your summer home maintenance tasks as well as getting your home ready for winter. Cold, snow, and rain can do a number to a home, so you don’t want to ignore winter preparation.

-   **Flush hot water heater and remove sediment.** This prolongs the life of the heater and helps with efficiency as well.
-   **Winterize air conditioning systems.** Remove and store window units. If you have central air, cover the outside unit with a tarp or plastic sheeting and secure with bungee cords.
-   **Get heating system ready for winter.** [Check for any leaks in windows or doors](https://www.diynetwork.com/how-to/rooms-and-spaces/doors-and-windows/how-to-check-and-seal-windows); these can cost an arm and a leg. Make sure heating vents are open and not blocked by furniture. Get furnace serviced/inspected at least every other year, preferably annually. As with the AC, this shouldn’t be a huge expense. Don’t forget about fireplaces if you have them.
-   **Turn off and flush outdoor water faucets.**Also flush hoses and store them. Winterize sprinkler systems as well, if you have one.
-   **Get chimney cleaned, if you have one.** Some folks say to do this in the spring, some say fall. Either way, just make sure it’s done once per year.
-   **[Test sump pump](https://www.hunker.com/12287797/how-to-test-a-basement-sump-pump).** You don’t want to wait until you need your sump pump to find out it’s not working.
-   **Check driveway/pavement for cracks.** Make sure to have re-sealed before winter; water can freeze and expand in the cracks, causing more damage.
-   **Buy winter gear.** Have sidewalk salt, good shovels, etc. ready for winter. You never know when that first snow will come!

# **Winter**

Winter is the time to go around the interior of your home and check for any little things you may have overlooked, or perhaps noticed and said, “I’ll get to that later.” Winter is your later. If you have any interior honey-do projects, whether it be painting, building shelves, etc., now is a great time to tackle those as well.

-   **Regularly check for ice dams and icicles.**De-icing cables that sit at the front of the roof work well. Don’t let icicles grow, as much as the kids may want you to. They’re not only a danger to people standing beneath them, but they’re incredibly heavy and can cause damage to your home. They also can cause water damage to your foundation when they melt.
-   **Test your electricity to the extent that you can.** Always, always be extra careful when working with electricity. You can do a couple things on your own, though. Check that all outlets work; if they don’t, you can re-wire them on your own. Also, [test your GFCI outlets](https://www.youtube.com/watch?v=Vkd43t2y2to). There are wildly varying opinions on how often to test this. Some say monthly, others say annually.
-   **Tighten any handles, knobs, racks, etc.** Go through the house and inspect anything that could have a loose screw.
-   **Check all locks and deadbolts on your doors and windows.** If anything doesn’t work right, replace.
-   **Check caulking around showers and bathtubs; repair as needed.**
-   **Remove showerheads and clean sediment.**This prolongs its life and helps with water pressure as well.
-   **Deep clean and inspect the basement.**Basements are notoriously overlooked, especially if they’re primarily just storage areas. Dust ‘em up, clean any windows, make sure there isn’t mold anywhere, etc. Give your basement a good inspection at least once a year